<?php
/**
 * Settings page template.
 *
 * @package TopRanker_AI
 * @since   1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get the admin instance.
$admin       = topranker_ai()->admin;
$current_tab = $admin->get_current_tab();
$tabs        = $admin->get_settings_tabs();
?>
<div class="wrap topranker-settings-wrap">
	<h1 class="topranker-settings-title">
		<span class="dashicons dashicons-chart-line" aria-hidden="true"></span>
		<?php esc_html_e( 'TopRanker AI Settings', 'topranker-ai' ); ?>
	</h1>

	<?php settings_errors( 'topranker_settings' ); ?>

	<nav class="nav-tab-wrapper topranker-tabs" aria-label="<?php esc_attr_e( 'Settings tabs', 'topranker-ai' ); ?>">
		<?php foreach ( $tabs as $tab_slug => $tab_label ) : ?>
			<a
				href="<?php echo esc_url( admin_url( 'admin.php?page=' . TopRanker_Admin::MENU_SLUG . '&tab=' . $tab_slug ) ); ?>"
				class="nav-tab <?php echo ( $current_tab === $tab_slug ) ? 'nav-tab-active' : ''; ?>"
				aria-current="<?php echo ( $current_tab === $tab_slug ) ? 'page' : 'false'; ?>"
			>
				<?php echo esc_html( $tab_label ); ?>
			</a>
		<?php endforeach; ?>
	</nav>

	<div class="topranker-settings-content">
		<?php if ( 'general' === $current_tab ) : ?>
			<form method="post" action="options.php" class="topranker-settings-form">
				<?php
				settings_fields( TopRanker_Admin::OPTION_GROUP );
				do_settings_sections( TopRanker_Admin::MENU_SLUG );
				submit_button( __( 'Save Settings', 'topranker-ai' ) );
				?>
			</form>
		<?php elseif ( 'usage' === $current_tab ) : ?>
			<?php
			// Get usage data from the Usage class.
			$usage_tracker = new TopRanker_Usage();
			$usage_stats   = $usage_tracker->get_stats();
			$count         = $usage_stats['used'];
			$limit         = $usage_stats['is_pro'] ? 0 : TopRanker_Usage::FREE_LIMIT;
			$percentage    = ( $limit > 0 ) ? min( 100, ( $count / $limit ) * 100 ) : 0;
			$reset_date    = $usage_stats['reset_date'];
			$is_warning    = $usage_stats['warning'];
			$is_at_limit   = $usage_stats['at_limit'];
			?>
			<div class="topranker-usage-section">
				<div class="topranker-usage-header">
					<h2><?php esc_html_e( 'Monthly Usage', 'topranker-ai' ); ?></h2>
					<?php if ( ! $usage_stats['is_pro'] ) : ?>
						<button
							type="button"
							id="topranker-refresh-usage"
							class="button button-secondary button-small"
							aria-label="<?php esc_attr_e( 'Refresh usage data', 'topranker-ai' ); ?>"
						>
							<span class="dashicons dashicons-update" aria-hidden="true"></span>
							<?php esc_html_e( 'Refresh', 'topranker-ai' ); ?>
						</button>
					<?php endif; ?>
				</div>

				<?php if ( $usage_stats['is_pro'] ) : ?>
					<div class="topranker-usage-pro">
						<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
						<p>
							<strong><?php esc_html_e( 'Unlimited Optimizations', 'topranker-ai' ); ?></strong><br>
							<?php esc_html_e( 'You have Pro access with unlimited optimizations.', 'topranker-ai' ); ?>
						</p>
					</div>
				<?php else : ?>
					<div class="topranker-usage-counter">
						<div class="topranker-usage-bar-wrapper">
							<div
								class="topranker-usage-bar"
								style="width: <?php echo esc_attr( $percentage ); ?>%;"
								role="progressbar"
								aria-valuenow="<?php echo esc_attr( $count ); ?>"
								aria-valuemin="0"
								aria-valuemax="<?php echo esc_attr( $limit ); ?>"
								aria-label="<?php esc_attr_e( 'Usage progress', 'topranker-ai' ); ?>"
							></div>
						</div>
						<p class="topranker-usage-text">
							<?php
							printf(
								/* translators: 1: current count, 2: limit */
								esc_html__( '%1$d of %2$d optimizations used this month', 'topranker-ai' ),
								$count,
								$limit
							);
							?>
						</p>
						<p class="topranker-usage-reset">
							<?php
							printf(
								/* translators: %s: reset date */
								esc_html__( 'Resets on %s', 'topranker-ai' ),
								esc_html( $reset_date )
							);
							?>
						</p>
					</div>

					<?php if ( $is_warning && ! $is_at_limit ) : ?>
						<div class="topranker-usage-warning notice notice-warning inline">
							<p>
								<?php
								printf(
									/* translators: %d: remaining count */
									esc_html__( 'You have %d optimizations remaining this month.', 'topranker-ai' ),
									$usage_stats['remaining']
								);
								?>
							</p>
						</div>
					<?php elseif ( $is_at_limit ) : ?>
						<div class="topranker-usage-limit notice notice-error inline">
							<p>
								<?php esc_html_e( 'You\'ve reached your monthly limit. Upgrade to Pro for unlimited optimizations.', 'topranker-ai' ); ?>
							</p>
						</div>
					<?php endif; ?>

					<?php
					$upgrade_url = topranker_get_upgrade_url();
					if ( $upgrade_url ) :
						?>
						<p>
							<a href="<?php echo esc_url( $upgrade_url ); ?>" class="button button-primary topranker-upgrade-button">
								<?php esc_html_e( 'Upgrade to Pro', 'topranker-ai' ); ?>
							</a>
						</p>
					<?php endif; ?>
				<?php endif; ?>
			</div>
		<?php endif; ?>
	</div>
</div>
