<?php
/**
 * Plugin Name:       TopRanker AI - SEO Optimizer
 * Plugin URI:        https://topranker.ai
 * Description:       AI-powered SEO optimization for your existing content. Generate meta titles, descriptions, keyphrases, social meta, and more using OpenAI.
 * Version:           1.0.0
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Author:            TopRanker AI
 * Author URI:        https://topranker.ai
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       topranker-ai
 * Domain Path:       /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Plugin constants.
 */
define( 'TOPRANKER_VERSION', '1.0.0' );
define( 'TOPRANKER_PATH', plugin_dir_path( __FILE__ ) );
define( 'TOPRANKER_URL', plugin_dir_url( __FILE__ ) );
define( 'TOPRANKER_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Initialize Freemius SDK.
 *
 * IMPORTANT: Freemius must be initialized BEFORE any other plugin code.
 */
if ( file_exists( TOPRANKER_PATH . 'includes/class-topranker-freemius.php' ) ) {
	require_once TOPRANKER_PATH . 'includes/class-topranker-freemius.php';
}

/**
 * Load the core plugin class.
 */
if ( file_exists( TOPRANKER_PATH . 'includes/class-topranker-core.php' ) ) {
	require_once TOPRANKER_PATH . 'includes/class-topranker-core.php';

	/**
	 * Returns the main plugin instance.
	 *
	 * @since 1.0.0
	 * @return TopRanker_Core
	 */
	function topranker_ai() {
		return TopRanker_Core::get_instance();
	}

	// Kick off the plugin.
	topranker_ai();
}
